def generate_response(invoice_line_ids):
    assert len(invoice_line_ids) == 5, "the mocked response is for 5 lines"
    for i, line in enumerate(response['lines']):
        line['lineNumber'] = 'account.move.line,%s' % invoice_line_ids[i].id
    return response


response = {'addresses': [{'boundaryLevel': 'Address',
                'city': 'San Francisco',
                'country': 'US',
                'id': 5000304937315,
                'latitude': '37.764754',
                'line1': '2280 Market St',
                'line2': '',
                'line3': '',
                'longitude': '-122.432634',
                'postalCode': '94114-1506',
                'region': 'CA',
                'taxRegionId': 4016940,
                'transactionId': 6000182165320},
               {'boundaryLevel': 'Address',
                'city': 'San Francisco',
                'country': 'US',
                'id': 6000304937315,
                'latitude': '37.71116',
                'line1': '250 Executive Park Blvd',
                'line2': '',
                'line3': '',
                'longitude': '-122.391717',
                'postalCode': '94134-3394',
                'region': 'CA',
                'taxRegionId': 4016940,
                'transactionId': 6000182165320}],
 'adjustmentDescription': '',
 'adjustmentReason': 'NotAdjusted',
 'batchCode': '',
 'businessIdentificationNo': '',
 'code': 'Journal Entry 67',
 'companyId': 281741,
 'country': 'US',
 'currencyCode': 'USD',
 'customerCode': 'CUST123456',
 'customerUsageType': '',
 'customerVendorCode': 'CUST123456',
 'date': '2021-01-01',
 'description': '',
 'destinationAddressId': 5000304937315,
 'email': '',
 'entityUseCode': '',
 'exchangeRate': 1.0,
 'exchangeRateCurrencyCode': 'USD',
 'exchangeRateEffectiveDate': '2021-01-01',
 'exemptNo': '',
 'id': 6000182165320,
 'lines': [{'boundaryOverrideId': 0,
            'businessIdentificationNo': '',
            'costInsuranceFreight': 0.0,
            'customerUsageType': '',
            'description': 'Odoo User',
            'destinationAddressId': 5000304937315,
            'details': [{'addressId': 6000304937315,
                         'country': 'US',
                         'countyFIPS': '',
                         'exemptAmount': 0.0,
                         'exemptReasonId': 4,
                         'exemptUnits': 0.0,
                         'id': 9000401706101,
                         'inState': True,
                         'isFee': False,
                         'isNonPassThru': False,
                         'jurisCode': '06',
                         'jurisName': 'CALIFORNIA',
                         'jurisType': 'STA',
                         'jurisdictionId': 5000531,
                         'jurisdictionType': 'State',
                         'liabilityType': 'Seller',
                         'nonTaxableAmount': 0.0,
                         'nonTaxableRuleId': 0,
                         'nonTaxableType': 'RateRule',
                         'nonTaxableUnits': 0.0,
                         'rate': 0.06,
                         'rateRuleId': 1525706,
                         'rateSourceId': 3,
                         'rateType': 'General',
                         'rateTypeCode': 'G',
                         'region': 'CA',
                         'reportingExemptUnits': 0.0,
                         'reportingNonTaxableUnits': 0.0,
                         'reportingTax': 2.1,
                         'reportingTaxCalculated': 2.1,
                         'reportingTaxableUnits': 35.0,
                         'serCode': '',
                         'signatureCode': 'AGAM',
                         'sourcing': 'Origin',
                         'stateAssignedNo': '',
                         'stateFIPS': '',
                         'tax': 2.1,
                         'taxAuthorityTypeId': 45,
                         'taxCalculated': 2.1,
                         'taxName': 'CA STATE TAX',
                         'taxOverride': 0.0,
                         'taxRegionId': 4016940,
                         'taxSubTypeId': 'S',
                         'taxType': 'Sales',
                         'taxTypeGroupId': 'SalesAndUse',
                         'taxableAmount': 35.0,
                         'taxableUnits': 35.0,
                         'transactionId': 6000182165320,
                         'transactionLineId': 10403927888,
                         'unitOfBasis': 'PerCurrencyUnit'},
                        {'addressId': 6000304937315,
                         'country': 'US',
                         'countyFIPS': '',
                         'exemptAmount': 0.0,
                         'exemptReasonId': 4,
                         'exemptUnits': 0.0,
                         'id': 10000401706103,
                         'inState': True,
                         'isFee': False,
                         'isNonPassThru': False,
                         'jurisCode': '075',
                         'jurisName': 'SAN FRANCISCO',
                         'jurisType': 'CTY',
                         'jurisdictionId': 275,
                         'jurisdictionType': 'County',
                         'liabilityType': 'Seller',
                         'nonTaxableAmount': 0.0,
                         'nonTaxableRuleId': 0,
                         'nonTaxableType': 'RateRule',
                         'nonTaxableUnits': 0.0,
                         'rate': 0.0025,
                         'rateRuleId': 1525710,
                         'rateSourceId': 3,
                         'rateType': 'General',
                         'rateTypeCode': 'G',
                         'region': 'CA',
                         'reportingExemptUnits': 0.0,
                         'reportingNonTaxableUnits': 0.0,
                         'reportingTax': 0.09,
                         'reportingTaxCalculated': 0.09,
                         'reportingTaxableUnits': 35.0,
                         'serCode': '',
                         'signatureCode': 'AIUQ',
                         'sourcing': 'Origin',
                         'stateAssignedNo': '',
                         'stateFIPS': '',
                         'tax': 0.09,
                         'taxAuthorityTypeId': 45,
                         'taxCalculated': 0.09,
                         'taxName': 'CA COUNTY TAX',
                         'taxOverride': 0.0,
                         'taxRegionId': 4016940,
                         'taxSubTypeId': 'S',
                         'taxType': 'Sales',
                         'taxTypeGroupId': 'SalesAndUse',
                         'taxableAmount': 35.0,
                         'taxableUnits': 35.0,
                         'transactionId': 6000182165320,
                         'transactionLineId': 10403927888,
                         'unitOfBasis': 'PerCurrencyUnit'},
                        {'addressId': 6000304937315,
                         'country': 'US',
                         'countyFIPS': '',
                         'exemptAmount': 0.0,
                         'exemptReasonId': 4,
                         'exemptUnits': 0.0,
                         'id': 11000401706101,
                         'inState': True,
                         'isFee': False,
                         'isNonPassThru': False,
                         'jurisCode': 'EMTV0',
                         'jurisName': 'SAN FRANCISCO CO LOCAL TAX SL',
                         'jurisType': 'STJ',
                         'jurisdictionId': 2001061792,
                         'jurisdictionType': 'Special',
                         'liabilityType': 'Seller',
                         'nonTaxableAmount': 0.0,
                         'nonTaxableRuleId': 0,
                         'nonTaxableType': 'RateRule',
                         'nonTaxableUnits': 0.0,
                         'rate': 0.01,
                         'rateRuleId': 1525730,
                         'rateSourceId': 3,
                         'rateType': 'General',
                         'rateTypeCode': 'G',
                         'region': 'CA',
                         'reportingExemptUnits': 0.0,
                         'reportingNonTaxableUnits': 0.0,
                         'reportingTax': 0.35,
                         'reportingTaxCalculated': 0.35,
                         'reportingTaxableUnits': 35.0,
                         'serCode': '',
                         'signatureCode': 'EMTV',
                         'sourcing': 'Origin',
                         'stateAssignedNo': '38',
                         'stateFIPS': '',
                         'tax': 0.35,
                         'taxAuthorityTypeId': 45,
                         'taxCalculated': 0.35,
                         'taxName': 'CA SPECIAL TAX',
                         'taxOverride': 0.0,
                         'taxRegionId': 4016940,
                         'taxSubTypeId': 'S',
                         'taxType': 'Sales',
                         'taxTypeGroupId': 'SalesAndUse',
                         'taxableAmount': 35.0,
                         'taxableUnits': 35.0,
                         'transactionId': 6000182165320,
                         'transactionLineId': 10403927888,
                         'unitOfBasis': 'PerCurrencyUnit'}],
            'discountAmount': 0.0,
            'discountTypeId': 0,
            'entityUseCode': '',
            'exemptAmount': 0.0,
            'exemptCertId': 0,
            'exemptNo': '',
            'hsCode': '',
            'id': 10403927888,
            'isItemTaxable': True,
            'isSSTP': False,
            'itemCode': 'false',
            'lineAmount': 35.0,
            'lineLocationTypes': [{'documentAddressId': 6000304937315,
                                   'documentLineId': 10403927888,
                                   'documentLineLocationTypeId': 11000385345219,
                                   'locationTypeCode': 'ShipFrom'},
                                  {'documentAddressId': 5000304937315,
                                   'documentLineId': 10403927888,
                                   'documentLineLocationTypeId': 12000385345218,
                                   'locationTypeCode': 'ShipTo'}],
            'lineNumber': 'account.move.line,229',
            'nonPassthroughDetails': [],
            'originAddressId': 6000304937315,
            'quantity': 1.0,
            'ref1': '',
            'ref2': '',
            'reportingDate': '2021-01-01',
            'revAccount': '',
            'sourcing': 'Origin',
            'tax': 2.54,
            'taxCalculated': 2.54,
            'taxCode': 'DC010000',
            'taxCodeId': 8575,
            'taxDate': '2021-01-01',
            'taxEngine': '',
            'taxIncluded': False,
            'taxOverrideAmount': 0.0,
            'taxOverrideReason': '',
            'taxOverrideType': 'None',
            'taxableAmount': 35.0,
            'transactionId': 6000182165320,
            'vatCode': '',
            'vatNumberTypeId': 0},
           {'boundaryOverrideId': 0,
            'businessIdentificationNo': '',
            'costInsuranceFreight': 0.0,
            'customerUsageType': '',
            'description': 'Odoo User Initial Discound',
            'destinationAddressId': 5000304937315,
            'details': [{'addressId': 6000304937315,
                         'country': 'US',
                         'countyFIPS': '',
                         'exemptAmount': 0.0,
                         'exemptReasonId': 4,
                         'exemptUnits': 0.0,
                         'id': 12000401706104,
                         'inState': True,
                         'isFee': False,
                         'isNonPassThru': False,
                         'jurisCode': '06',
                         'jurisName': 'CALIFORNIA',
                         'jurisType': 'STA',
                         'jurisdictionId': 5000531,
                         'jurisdictionType': 'State',
                         'liabilityType': 'Seller',
                         'nonTaxableAmount': 0.0,
                         'nonTaxableRuleId': 0,
                         'nonTaxableType': 'RateRule',
                         'nonTaxableUnits': 0.0,
                         'rate': 0.06,
                         'rateRuleId': 1525706,
                         'rateSourceId': 3,
                         'rateType': 'General',
                         'rateTypeCode': 'G',
                         'region': 'CA',
                         'reportingExemptUnits': 0.0,
                         'reportingNonTaxableUnits': 0.0,
                         'reportingTax': -0.3,
                         'reportingTaxCalculated': -0.3,
                         'reportingTaxableUnits': -5.0,
                         'serCode': '',
                         'signatureCode': 'AGAM',
                         'sourcing': 'Origin',
                         'stateAssignedNo': '',
                         'stateFIPS': '',
                         'tax': -0.3,
                         'taxAuthorityTypeId': 45,
                         'taxCalculated': -0.3,
                         'taxName': 'CA STATE TAX',
                         'taxOverride': 0.0,
                         'taxRegionId': 4016940,
                         'taxSubTypeId': 'S',
                         'taxType': 'Sales',
                         'taxTypeGroupId': 'SalesAndUse',
                         'taxableAmount': -5.0,
                         'taxableUnits': -5.0,
                         'transactionId': 6000182165320,
                         'transactionLineId': 12612264132,
                         'unitOfBasis': 'PerCurrencyUnit'},
                        {'addressId': 6000304937315,
                         'country': 'US',
                         'countyFIPS': '',
                         'exemptAmount': 0.0,
                         'exemptReasonId': 4,
                         'exemptUnits': 0.0,
                         'id': 1000514307628,
                         'inState': True,
                         'isFee': False,
                         'isNonPassThru': False,
                         'jurisCode': '075',
                         'jurisName': 'SAN FRANCISCO',
                         'jurisType': 'CTY',
                         'jurisdictionId': 275,
                         'jurisdictionType': 'County',
                         'liabilityType': 'Seller',
                         'nonTaxableAmount': 0.0,
                         'nonTaxableRuleId': 0,
                         'nonTaxableType': 'RateRule',
                         'nonTaxableUnits': 0.0,
                         'rate': 0.0025,
                         'rateRuleId': 1525710,
                         'rateSourceId': 3,
                         'rateType': 'General',
                         'rateTypeCode': 'G',
                         'region': 'CA',
                         'reportingExemptUnits': 0.0,
                         'reportingNonTaxableUnits': 0.0,
                         'reportingTax': -0.01,
                         'reportingTaxCalculated': -0.01,
                         'reportingTaxableUnits': -5.0,
                         'serCode': '',
                         'signatureCode': 'AIUQ',
                         'sourcing': 'Origin',
                         'stateAssignedNo': '',
                         'stateFIPS': '',
                         'tax': -0.01,
                         'taxAuthorityTypeId': 45,
                         'taxCalculated': -0.01,
                         'taxName': 'CA COUNTY TAX',
                         'taxOverride': 0.0,
                         'taxRegionId': 4016940,
                         'taxSubTypeId': 'S',
                         'taxType': 'Sales',
                         'taxTypeGroupId': 'SalesAndUse',
                         'taxableAmount': -5.0,
                         'taxableUnits': -5.0,
                         'transactionId': 6000182165320,
                         'transactionLineId': 12612264132,
                         'unitOfBasis': 'PerCurrencyUnit'},
                        {'addressId': 6000304937315,
                         'country': 'US',
                         'countyFIPS': '',
                         'exemptAmount': 0.0,
                         'exemptReasonId': 4,
                         'exemptUnits': 0.0,
                         'id': 2000514307626,
                         'inState': True,
                         'isFee': False,
                         'isNonPassThru': False,
                         'jurisCode': 'EMTV0',
                         'jurisName': 'SAN FRANCISCO CO LOCAL TAX SL',
                         'jurisType': 'STJ',
                         'jurisdictionId': 2001061792,
                         'jurisdictionType': 'Special',
                         'liabilityType': 'Seller',
                         'nonTaxableAmount': 0.0,
                         'nonTaxableRuleId': 0,
                         'nonTaxableType': 'RateRule',
                         'nonTaxableUnits': 0.0,
                         'rate': 0.01,
                         'rateRuleId': 1525730,
                         'rateSourceId': 3,
                         'rateType': 'General',
                         'rateTypeCode': 'G',
                         'region': 'CA',
                         'reportingExemptUnits': 0.0,
                         'reportingNonTaxableUnits': 0.0,
                         'reportingTax': -0.05,
                         'reportingTaxCalculated': -0.05,
                         'reportingTaxableUnits': -5.0,
                         'serCode': '',
                         'signatureCode': 'EMTV',
                         'sourcing': 'Origin',
                         'stateAssignedNo': '38',
                         'stateFIPS': '',
                         'tax': -0.05,
                         'taxAuthorityTypeId': 45,
                         'taxCalculated': -0.05,
                         'taxName': 'CA SPECIAL TAX',
                         'taxOverride': 0.0,
                         'taxRegionId': 4016940,
                         'taxSubTypeId': 'S',
                         'taxType': 'Sales',
                         'taxTypeGroupId': 'SalesAndUse',
                         'taxableAmount': -5.0,
                         'taxableUnits': -5.0,
                         'transactionId': 6000182165320,
                         'transactionLineId': 12612264132,
                         'unitOfBasis': 'PerCurrencyUnit'}],
            'discountAmount': 0.0,
            'discountTypeId': 0,
            'entityUseCode': '',
            'exemptAmount': 0.0,
            'exemptCertId': 0,
            'exemptNo': '',
            'hsCode': '',
            'id': 12612264132,
            'isItemTaxable': True,
            'isSSTP': False,
            'itemCode': 'false',
            'lineAmount': -5.0,
            'lineLocationTypes': [{'documentAddressId': 6000304937315,
                                   'documentLineId': 12612264132,
                                   'documentLineLocationTypeId': 7335935470,
                                   'locationTypeCode': 'ShipFrom'},
                                  {'documentAddressId': 5000304937315,
                                   'documentLineId': 12612264132,
                                   'documentLineLocationTypeId': 9335935467,
                                   'locationTypeCode': 'ShipTo'}],
            'lineNumber': 'account.move.line,230',
            'nonPassthroughDetails': [],
            'originAddressId': 6000304937315,
            'quantity': 1.0,
            'ref1': '',
            'ref2': '',
            'reportingDate': '2021-01-01',
            'revAccount': '',
            'sourcing': 'Origin',
            'tax': -0.36,
            'taxCalculated': -0.36,
            'taxCode': 'DC010000',
            'taxCodeId': 8575,
            'taxDate': '2021-01-01',
            'taxEngine': '',
            'taxIncluded': False,
            'taxOverrideAmount': 0.0,
            'taxOverrideReason': '',
            'taxOverrideType': 'None',
            'taxableAmount': -5.0,
            'transactionId': 6000182165320,
            'vatCode': '',
            'vatNumberTypeId': 0},
           {'boundaryOverrideId': 0,
            'businessIdentificationNo': '',
            'costInsuranceFreight': 0.0,
            'customerUsageType': '',
            'description': 'Accounting',
            'destinationAddressId': 5000304937315,
            'details': [{'addressId': 6000304937315,
                         'country': 'US',
                         'countyFIPS': '',
                         'exemptAmount': 0.0,
                         'exemptReasonId': 4,
                         'exemptUnits': 0.0,
                         'id': 3000514307625,
                         'inState': True,
                         'isFee': False,
                         'isNonPassThru': False,
                         'jurisCode': '06',
                         'jurisName': 'CALIFORNIA',
                         'jurisType': 'STA',
                         'jurisdictionId': 5000531,
                         'jurisdictionType': 'State',
                         'liabilityType': 'Seller',
                         'nonTaxableAmount': 0.0,
                         'nonTaxableRuleId': 0,
                         'nonTaxableType': 'RateRule',
                         'nonTaxableUnits': 0.0,
                         'rate': 0.06,
                         'rateRuleId': 1525706,
                         'rateSourceId': 3,
                         'rateType': 'General',
                         'rateTypeCode': 'G',
                         'region': 'CA',
                         'reportingExemptUnits': 0.0,
                         'reportingNonTaxableUnits': 0.0,
                         'reportingTax': 1.8,
                         'reportingTaxCalculated': 1.8,
                         'reportingTaxableUnits': 30.0,
                         'serCode': '',
                         'signatureCode': 'AGAM',
                         'sourcing': 'Origin',
                         'stateAssignedNo': '',
                         'stateFIPS': '',
                         'tax': 1.8,
                         'taxAuthorityTypeId': 45,
                         'taxCalculated': 1.8,
                         'taxName': 'CA STATE TAX',
                         'taxOverride': 0.0,
                         'taxRegionId': 4016940,
                         'taxSubTypeId': 'S',
                         'taxType': 'Sales',
                         'taxTypeGroupId': 'SalesAndUse',
                         'taxableAmount': 30.0,
                         'taxableUnits': 30.0,
                         'transactionId': 6000182165320,
                         'transactionLineId': 5000310450103,
                         'unitOfBasis': 'PerCurrencyUnit'},
                        {'addressId': 6000304937315,
                         'country': 'US',
                         'countyFIPS': '',
                         'exemptAmount': 0.0,
                         'exemptReasonId': 4,
                         'exemptUnits': 0.0,
                         'id': 4000514307623,
                         'inState': True,
                         'isFee': False,
                         'isNonPassThru': False,
                         'jurisCode': '075',
                         'jurisName': 'SAN FRANCISCO',
                         'jurisType': 'CTY',
                         'jurisdictionId': 275,
                         'jurisdictionType': 'County',
                         'liabilityType': 'Seller',
                         'nonTaxableAmount': 0.0,
                         'nonTaxableRuleId': 0,
                         'nonTaxableType': 'RateRule',
                         'nonTaxableUnits': 0.0,
                         'rate': 0.0025,
                         'rateRuleId': 1525710,
                         'rateSourceId': 3,
                         'rateType': 'General',
                         'rateTypeCode': 'G',
                         'region': 'CA',
                         'reportingExemptUnits': 0.0,
                         'reportingNonTaxableUnits': 0.0,
                         'reportingTax': 0.08,
                         'reportingTaxCalculated': 0.08,
                         'reportingTaxableUnits': 30.0,
                         'serCode': '',
                         'signatureCode': 'AIUQ',
                         'sourcing': 'Origin',
                         'stateAssignedNo': '',
                         'stateFIPS': '',
                         'tax': 0.08,
                         'taxAuthorityTypeId': 45,
                         'taxCalculated': 0.08,
                         'taxName': 'CA COUNTY TAX',
                         'taxOverride': 0.0,
                         'taxRegionId': 4016940,
                         'taxSubTypeId': 'S',
                         'taxType': 'Sales',
                         'taxTypeGroupId': 'SalesAndUse',
                         'taxableAmount': 30.0,
                         'taxableUnits': 30.0,
                         'transactionId': 6000182165320,
                         'transactionLineId': 5000310450103,
                         'unitOfBasis': 'PerCurrencyUnit'},
                        {'addressId': 6000304937315,
                         'country': 'US',
                         'countyFIPS': '',
                         'exemptAmount': 0.0,
                         'exemptReasonId': 4,
                         'exemptUnits': 0.0,
                         'id': 5000514307621,
                         'inState': True,
                         'isFee': False,
                         'isNonPassThru': False,
                         'jurisCode': 'EMTV0',
                         'jurisName': 'SAN FRANCISCO CO LOCAL TAX SL',
                         'jurisType': 'STJ',
                         'jurisdictionId': 2001061792,
                         'jurisdictionType': 'Special',
                         'liabilityType': 'Seller',
                         'nonTaxableAmount': 0.0,
                         'nonTaxableRuleId': 0,
                         'nonTaxableType': 'RateRule',
                         'nonTaxableUnits': 0.0,
                         'rate': 0.01,
                         'rateRuleId': 1525730,
                         'rateSourceId': 3,
                         'rateType': 'General',
                         'rateTypeCode': 'G',
                         'region': 'CA',
                         'reportingExemptUnits': 0.0,
                         'reportingNonTaxableUnits': 0.0,
                         'reportingTax': 0.3,
                         'reportingTaxCalculated': 0.3,
                         'reportingTaxableUnits': 30.0,
                         'serCode': '',
                         'signatureCode': 'EMTV',
                         'sourcing': 'Origin',
                         'stateAssignedNo': '38',
                         'stateFIPS': '',
                         'tax': 0.3,
                         'taxAuthorityTypeId': 45,
                         'taxCalculated': 0.3,
                         'taxName': 'CA SPECIAL TAX',
                         'taxOverride': 0.0,
                         'taxRegionId': 4016940,
                         'taxSubTypeId': 'S',
                         'taxType': 'Sales',
                         'taxTypeGroupId': 'SalesAndUse',
                         'taxableAmount': 30.0,
                         'taxableUnits': 30.0,
                         'transactionId': 6000182165320,
                         'transactionLineId': 5000310450103,
                         'unitOfBasis': 'PerCurrencyUnit'}],
            'discountAmount': 0.0,
            'discountTypeId': 0,
            'entityUseCode': '',
            'exemptAmount': 0.0,
            'exemptCertId': 0,
            'exemptNo': '',
            'hsCode': '',
            'id': 5000310450103,
            'isItemTaxable': True,
            'isSSTP': False,
            'itemCode': 'false',
            'lineAmount': 30.0,
            'lineLocationTypes': [{'documentAddressId': 6000304937315,
                                   'documentLineId': 5000310450103,
                                   'documentLineLocationTypeId': 11335935467,
                                   'locationTypeCode': 'ShipFrom'},
                                  {'documentAddressId': 5000304937315,
                                   'documentLineId': 5000310450103,
                                   'documentLineLocationTypeId': 13552993608,
                                   'locationTypeCode': 'ShipTo'}],
            'lineNumber': 'account.move.line,231',
            'nonPassthroughDetails': [],
            'originAddressId': 6000304937315,
            'quantity': 1.0,
            'ref1': '',
            'ref2': '',
            'reportingDate': '2021-01-01',
            'revAccount': '',
            'sourcing': 'Origin',
            'tax': 2.18,
            'taxCalculated': 2.18,
            'taxCode': 'DC010000',
            'taxCodeId': 8575,
            'taxDate': '2021-01-01',
            'taxEngine': '',
            'taxIncluded': False,
            'taxOverrideAmount': 0.0,
            'taxOverrideReason': '',
            'taxOverrideType': 'None',
            'taxableAmount': 30.0,
            'transactionId': 6000182165320,
            'vatCode': '',
            'vatNumberTypeId': 0},
           {'boundaryOverrideId': 0,
            'businessIdentificationNo': '',
            'costInsuranceFreight': 0.0,
            'customerUsageType': '',
            'description': 'Expenses',
            'destinationAddressId': 5000304937315,
            'details': [{'addressId': 6000304937315,
                         'country': 'US',
                         'countyFIPS': '',
                         'exemptAmount': 0.0,
                         'exemptReasonId': 4,
                         'exemptUnits': 0.0,
                         'id': 6000514307620,
                         'inState': True,
                         'isFee': False,
                         'isNonPassThru': False,
                         'jurisCode': '06',
                         'jurisName': 'CALIFORNIA',
                         'jurisType': 'STA',
                         'jurisdictionId': 5000531,
                         'jurisdictionType': 'State',
                         'liabilityType': 'Seller',
                         'nonTaxableAmount': 0.0,
                         'nonTaxableRuleId': 0,
                         'nonTaxableType': 'RateRule',
                         'nonTaxableUnits': 0.0,
                         'rate': 0.06,
                         'rateRuleId': 1525706,
                         'rateSourceId': 3,
                         'rateType': 'General',
                         'rateTypeCode': 'G',
                         'region': 'CA',
                         'reportingExemptUnits': 0.0,
                         'reportingNonTaxableUnits': 0.0,
                         'reportingTax': 0.9,
                         'reportingTaxCalculated': 0.9,
                         'reportingTaxableUnits': 15.0,
                         'serCode': '',
                         'signatureCode': 'AGAM',
                         'sourcing': 'Origin',
                         'stateAssignedNo': '',
                         'stateFIPS': '',
                         'tax': 0.9,
                         'taxAuthorityTypeId': 45,
                         'taxCalculated': 0.9,
                         'taxName': 'CA STATE TAX',
                         'taxOverride': 0.0,
                         'taxRegionId': 4016940,
                         'taxSubTypeId': 'S',
                         'taxType': 'Sales',
                         'taxTypeGroupId': 'SalesAndUse',
                         'taxableAmount': 15.0,
                         'taxableUnits': 15.0,
                         'transactionId': 6000182165320,
                         'transactionLineId': 6000310450101,
                         'unitOfBasis': 'PerCurrencyUnit'},
                        {'addressId': 6000304937315,
                         'country': 'US',
                         'countyFIPS': '',
                         'exemptAmount': 0.0,
                         'exemptReasonId': 4,
                         'exemptUnits': 0.0,
                         'id': 8000401706100,
                         'inState': True,
                         'isFee': False,
                         'isNonPassThru': False,
                         'jurisCode': '075',
                         'jurisName': 'SAN FRANCISCO',
                         'jurisType': 'CTY',
                         'jurisdictionId': 275,
                         'jurisdictionType': 'County',
                         'liabilityType': 'Seller',
                         'nonTaxableAmount': 0.0,
                         'nonTaxableRuleId': 0,
                         'nonTaxableType': 'RateRule',
                         'nonTaxableUnits': 0.0,
                         'rate': 0.0025,
                         'rateRuleId': 1525710,
                         'rateSourceId': 3,
                         'rateType': 'General',
                         'rateTypeCode': 'G',
                         'region': 'CA',
                         'reportingExemptUnits': 0.0,
                         'reportingNonTaxableUnits': 0.0,
                         'reportingTax': 0.04,
                         'reportingTaxCalculated': 0.04,
                         'reportingTaxableUnits': 15.0,
                         'serCode': '',
                         'signatureCode': 'AIUQ',
                         'sourcing': 'Origin',
                         'stateAssignedNo': '',
                         'stateFIPS': '',
                         'tax': 0.04,
                         'taxAuthorityTypeId': 45,
                         'taxCalculated': 0.04,
                         'taxName': 'CA COUNTY TAX',
                         'taxOverride': 0.0,
                         'taxRegionId': 4016940,
                         'taxSubTypeId': 'S',
                         'taxType': 'Sales',
                         'taxTypeGroupId': 'SalesAndUse',
                         'taxableAmount': 15.0,
                         'taxableUnits': 15.0,
                         'transactionId': 6000182165320,
                         'transactionLineId': 6000310450101,
                         'unitOfBasis': 'PerCurrencyUnit'},
                        {'addressId': 6000304937315,
                         'country': 'US',
                         'countyFIPS': '',
                         'exemptAmount': 0.0,
                         'exemptReasonId': 4,
                         'exemptUnits': 0.0,
                         'id': 11000401706102,
                         'inState': True,
                         'isFee': False,
                         'isNonPassThru': False,
                         'jurisCode': 'EMTV0',
                         'jurisName': 'SAN FRANCISCO CO LOCAL TAX SL',
                         'jurisType': 'STJ',
                         'jurisdictionId': 2001061792,
                         'jurisdictionType': 'Special',
                         'liabilityType': 'Seller',
                         'nonTaxableAmount': 0.0,
                         'nonTaxableRuleId': 0,
                         'nonTaxableType': 'RateRule',
                         'nonTaxableUnits': 0.0,
                         'rate': 0.01,
                         'rateRuleId': 1525730,
                         'rateSourceId': 3,
                         'rateType': 'General',
                         'rateTypeCode': 'G',
                         'region': 'CA',
                         'reportingExemptUnits': 0.0,
                         'reportingNonTaxableUnits': 0.0,
                         'reportingTax': 0.15,
                         'reportingTaxCalculated': 0.15,
                         'reportingTaxableUnits': 15.0,
                         'serCode': '',
                         'signatureCode': 'EMTV',
                         'sourcing': 'Origin',
                         'stateAssignedNo': '38',
                         'stateFIPS': '',
                         'tax': 0.15,
                         'taxAuthorityTypeId': 45,
                         'taxCalculated': 0.15,
                         'taxName': 'CA SPECIAL TAX',
                         'taxOverride': 0.0,
                         'taxRegionId': 4016940,
                         'taxSubTypeId': 'S',
                         'taxType': 'Sales',
                         'taxTypeGroupId': 'SalesAndUse',
                         'taxableAmount': 15.0,
                         'taxableUnits': 15.0,
                         'transactionId': 6000182165320,
                         'transactionLineId': 6000310450101,
                         'unitOfBasis': 'PerCurrencyUnit'}],
            'discountAmount': 0.0,
            'discountTypeId': 0,
            'entityUseCode': '',
            'exemptAmount': 0.0,
            'exemptCertId': 0,
            'exemptNo': '',
            'hsCode': '',
            'id': 6000310450101,
            'isItemTaxable': True,
            'isSSTP': False,
            'itemCode': 'false',
            'lineAmount': 15.0,
            'lineLocationTypes': [{'documentAddressId': 6000304937315,
                                   'documentLineId': 6000310450101,
                                   'documentLineLocationTypeId': 5000485005854,
                                   'locationTypeCode': 'ShipFrom'},
                                  {'documentAddressId': 5000304937315,
                                   'documentLineId': 6000310450101,
                                   'documentLineLocationTypeId': 6000485005854,
                                   'locationTypeCode': 'ShipTo'}],
            'lineNumber': 'account.move.line,232',
            'nonPassthroughDetails': [],
            'originAddressId': 6000304937315,
            'quantity': 1.0,
            'ref1': '',
            'ref2': '',
            'reportingDate': '2021-01-01',
            'revAccount': '',
            'sourcing': 'Origin',
            'tax': 1.09,
            'taxCalculated': 1.09,
            'taxCode': 'DC010000',
            'taxCodeId': 8575,
            'taxDate': '2021-01-01',
            'taxEngine': '',
            'taxIncluded': False,
            'taxOverrideAmount': 0.0,
            'taxOverrideReason': '',
            'taxOverrideType': 'None',
            'taxableAmount': 15.0,
            'transactionId': 6000182165320,
            'vatCode': '',
            'vatNumberTypeId': 0},
           {'boundaryOverrideId': 0,
            'businessIdentificationNo': '',
            'costInsuranceFreight': 0.0,
            'customerUsageType': '',
            'description': 'Invoicing',
            'destinationAddressId': 5000304937315,
            'details': [{'addressId': 6000304937315,
                         'country': 'US',
                         'countyFIPS': '',
                         'exemptAmount': 0.0,
                         'exemptReasonId': 4,
                         'exemptUnits': 0.0,
                         'id': 2000514307627,
                         'inState': True,
                         'isFee': False,
                         'isNonPassThru': False,
                         'jurisCode': '06',
                         'jurisName': 'CALIFORNIA',
                         'jurisType': 'STA',
                         'jurisdictionId': 5000531,
                         'jurisdictionType': 'State',
                         'liabilityType': 'Seller',
                         'nonTaxableAmount': 0.0,
                         'nonTaxableRuleId': 0,
                         'nonTaxableType': 'RateRule',
                         'nonTaxableUnits': 0.0,
                         'rate': 0.06,
                         'rateRuleId': 1525706,
                         'rateSourceId': 3,
                         'rateType': 'General',
                         'rateTypeCode': 'G',
                         'region': 'CA',
                         'reportingExemptUnits': 0.0,
                         'reportingNonTaxableUnits': 0.0,
                         'reportingTax': 0.9,
                         'reportingTaxCalculated': 0.9,
                         'reportingTaxableUnits': 15.0,
                         'serCode': '',
                         'signatureCode': 'AGAM',
                         'sourcing': 'Origin',
                         'stateAssignedNo': '',
                         'stateFIPS': '',
                         'tax': 0.9,
                         'taxAuthorityTypeId': 45,
                         'taxCalculated': 0.9,
                         'taxName': 'CA STATE TAX',
                         'taxOverride': 0.0,
                         'taxRegionId': 4016940,
                         'taxSubTypeId': 'S',
                         'taxType': 'Sales',
                         'taxTypeGroupId': 'SalesAndUse',
                         'taxableAmount': 15.0,
                         'taxableUnits': 15.0,
                         'transactionId': 6000182165320,
                         'transactionLineId': 6403927890,
                         'unitOfBasis': 'PerCurrencyUnit'},
                        {'addressId': 6000304937315,
                         'country': 'US',
                         'countyFIPS': '',
                         'exemptAmount': 0.0,
                         'exemptReasonId': 4,
                         'exemptUnits': 0.0,
                         'id': 4000514307624,
                         'inState': True,
                         'isFee': False,
                         'isNonPassThru': False,
                         'jurisCode': '075',
                         'jurisName': 'SAN FRANCISCO',
                         'jurisType': 'CTY',
                         'jurisdictionId': 275,
                         'jurisdictionType': 'County',
                         'liabilityType': 'Seller',
                         'nonTaxableAmount': 0.0,
                         'nonTaxableRuleId': 0,
                         'nonTaxableType': 'RateRule',
                         'nonTaxableUnits': 0.0,
                         'rate': 0.0025,
                         'rateRuleId': 1525710,
                         'rateSourceId': 3,
                         'rateType': 'General',
                         'rateTypeCode': 'G',
                         'region': 'CA',
                         'reportingExemptUnits': 0.0,
                         'reportingNonTaxableUnits': 0.0,
                         'reportingTax': 0.04,
                         'reportingTaxCalculated': 0.04,
                         'reportingTaxableUnits': 15.0,
                         'serCode': '',
                         'signatureCode': 'AIUQ',
                         'sourcing': 'Origin',
                         'stateAssignedNo': '',
                         'stateFIPS': '',
                         'tax': 0.04,
                         'taxAuthorityTypeId': 45,
                         'taxCalculated': 0.04,
                         'taxName': 'CA COUNTY TAX',
                         'taxOverride': 0.0,
                         'taxRegionId': 4016940,
                         'taxSubTypeId': 'S',
                         'taxType': 'Sales',
                         'taxTypeGroupId': 'SalesAndUse',
                         'taxableAmount': 15.0,
                         'taxableUnits': 15.0,
                         'transactionId': 6000182165320,
                         'transactionLineId': 6403927890,
                         'unitOfBasis': 'PerCurrencyUnit'},
                        {'addressId': 6000304937315,
                         'country': 'US',
                         'countyFIPS': '',
                         'exemptAmount': 0.0,
                         'exemptReasonId': 4,
                         'exemptUnits': 0.0,
                         'id': 5000514307622,
                         'inState': True,
                         'isFee': False,
                         'isNonPassThru': False,
                         'jurisCode': 'EMTV0',
                         'jurisName': 'SAN FRANCISCO CO LOCAL TAX SL',
                         'jurisType': 'STJ',
                         'jurisdictionId': 2001061792,
                         'jurisdictionType': 'Special',
                         'liabilityType': 'Seller',
                         'nonTaxableAmount': 0.0,
                         'nonTaxableRuleId': 0,
                         'nonTaxableType': 'RateRule',
                         'nonTaxableUnits': 0.0,
                         'rate': 0.01,
                         'rateRuleId': 1525730,
                         'rateSourceId': 3,
                         'rateType': 'General',
                         'rateTypeCode': 'G',
                         'region': 'CA',
                         'reportingExemptUnits': 0.0,
                         'reportingNonTaxableUnits': 0.0,
                         'reportingTax': 0.15,
                         'reportingTaxCalculated': 0.15,
                         'reportingTaxableUnits': 15.0,
                         'serCode': '',
                         'signatureCode': 'EMTV',
                         'sourcing': 'Origin',
                         'stateAssignedNo': '38',
                         'stateFIPS': '',
                         'tax': 0.15,
                         'taxAuthorityTypeId': 45,
                         'taxCalculated': 0.15,
                         'taxName': 'CA SPECIAL TAX',
                         'taxOverride': 0.0,
                         'taxRegionId': 4016940,
                         'taxSubTypeId': 'S',
                         'taxType': 'Sales',
                         'taxTypeGroupId': 'SalesAndUse',
                         'taxableAmount': 15.0,
                         'taxableUnits': 15.0,
                         'transactionId': 6000182165320,
                         'transactionLineId': 6403927890,
                         'unitOfBasis': 'PerCurrencyUnit'}],
            'discountAmount': 0.0,
            'discountTypeId': 0,
            'entityUseCode': '',
            'exemptAmount': 0.0,
            'exemptCertId': 0,
            'exemptNo': '',
            'hsCode': '',
            'id': 6403927890,
            'isItemTaxable': True,
            'isSSTP': False,
            'itemCode': 'false',
            'lineAmount': 15.0,
            'lineLocationTypes': [{'documentAddressId': 6000304937315,
                                   'documentLineId': 6403927890,
                                   'documentLineLocationTypeId': 11000385345220,
                                   'locationTypeCode': 'ShipFrom'},
                                  {'documentAddressId': 5000304937315,
                                   'documentLineId': 6403927890,
                                   'documentLineLocationTypeId': 12000385345219,
                                   'locationTypeCode': 'ShipTo'}],
            'lineNumber': 'account.move.line,233',
            'nonPassthroughDetails': [],
            'originAddressId': 6000304937315,
            'quantity': 1.0,
            'ref1': '',
            'ref2': '',
            'reportingDate': '2021-01-01',
            'revAccount': '',
            'sourcing': 'Origin',
            'tax': 1.09,
            'taxCalculated': 1.09,
            'taxCode': 'DC010000',
            'taxCodeId': 8575,
            'taxDate': '2021-01-01',
            'taxEngine': '',
            'taxIncluded': False,
            'taxOverrideAmount': 0.0,
            'taxOverrideReason': '',
            'taxOverrideType': 'None',
            'taxableAmount': 15.0,
            'transactionId': 6000182165320,
            'vatCode': '',
            'vatNumberTypeId': 0}],
 'locationCode': '',
 'locationTypes': [{'documentAddressId': 6000304937315,
                    'documentId': 6000182165320,
                    'documentLocationTypeId': 11254474859,
                    'locationTypeCode': 'ShipFrom'},
                   {'documentAddressId': 5000304937315,
                    'documentId': 6000182165320,
                    'documentLocationTypeId': 5000269681192,
                    'locationTypeCode': 'ShipTo'}],
 'locked': False,
 'modifiedDate': '2021-09-24T19:39:27.7013484Z',
 'modifiedUserId': 212768,
 'originAddressId': 6000304937315,
 'purchaseOrderNo': '',
 'reconciled': False,
 'referenceCode': 'INV/2021/01/0001',
 'region': 'CA',
 'reportingLocationCode': '',
 'salespersonCode': '',
 'softwareVersion': '21.8.1.0',
 'status': 'Saved',
 'summary': [{'country': 'US',
              'exemption': 0.0,
              'jurisCode': '06',
              'jurisName': 'CALIFORNIA',
              'jurisType': 'State',
              'nonTaxable': 0.0,
              'rate': 0.06,
              'rateType': 'General',
              'region': 'CA',
              'stateAssignedNo': '',
              'tax': 5.4,
              'taxAuthorityType': 45,
              'taxCalculated': 5.4,
              'taxName': 'CA STATE TAX',
              'taxSubType': 'S',
              'taxType': 'Sales',
              'taxable': 90.0},
             {'country': 'US',
              'exemption': 0.0,
              'jurisCode': '075',
              'jurisName': 'SAN FRANCISCO',
              'jurisType': 'County',
              'nonTaxable': 0.0,
              'rate': 0.0025,
              'rateType': 'General',
              'region': 'CA',
              'stateAssignedNo': '',
              'tax': 0.24,
              'taxAuthorityType': 45,
              'taxCalculated': 0.24,
              'taxName': 'CA COUNTY TAX',
              'taxSubType': 'S',
              'taxType': 'Sales',
              'taxable': 90.0},
             {'country': 'US',
              'exemption': 0.0,
              'jurisCode': 'EMTV0',
              'jurisName': 'SAN FRANCISCO CO LOCAL TAX SL',
              'jurisType': 'Special',
              'nonTaxable': 0.0,
              'rate': 0.01,
              'rateType': 'General',
              'region': 'CA',
              'stateAssignedNo': '38',
              'tax': 0.9,
              'taxAuthorityType': 45,
              'taxCalculated': 0.9,
              'taxName': 'CA SPECIAL TAX',
              'taxSubType': 'S',
              'taxType': 'Sales',
              'taxable': 90.0}],
 'taxDate': '2021-01-01',
 'taxOverrideAmount': 0.0,
 'taxOverrideReason': '',
 'taxOverrideType': 'None',
 'totalAmount': 90.0,
 'totalDiscount': 0.0,
 'totalExempt': 0.0,
 'totalTax': 6.54,
 'totalTaxCalculated': 6.54,
 'totalTaxable': 90.0,
 'type': 'SalesInvoice',
 'version': 1}
