# -*- coding: utf-8 -*-

from odoo import models, fields, api
import logging
_logger = logging.getLogger(__name__)


class ProductTemplate(models.Model):
    _inherit = "product.template"
    
    _sql_constraints = [
        ('default_code_company_uniq', 'unique(default_code,company_id)', 'La réference interne doit être unique par société!!')
    ]
    
    @api.model
    def create(self, vals):
        if 'company_id' not in vals or not vals['company_id']:
            vals['company_id'] = self.env.user.company_id.id
        
        if 'default_code' not in vals or not vals['default_code']:
            vals['default_code'] = self.env['ir.sequence'].next_by_code('product_code')
    
        return super(ProductTemplate, self).create(vals)
