# -*- coding: utf-8 -*-

from odoo import models, fields, api, _
from odoo.osv import expression


class SupplierInfo(models.Model):
    _inherit = "product.supplierinfo"
    
    
    def name_get(self):
        res = []
        for ps in self:
            name = "%s ‒ %s" % (ps.name.name, ps.product_name)
            res.append((ps.id, name))
        return res
        
        
    @api.model
    def _name_search(self, name, args=None, operator='ilike', limit=100, name_get_uid=None):
        if self._context.get('sale_show_supplierproduct_name'):
            if operator == 'ilike' and not (name or '').strip():
                domain = []
            elif operator in ('ilike', 'like', '=', '=like', '=ilike'):
                domain = expression.AND([
                    args or [],
                    ['|', ('product_name', operator, name), ('product_code', operator, name)]
                ])
                return self._search(domain, limit=limit, access_rights_uid=name_get_uid)
        return super(SupplierInfo, self)._name_search(name, args=args, operator=operator, limit=limit, name_get_uid=name_get_uid)