# -*- coding: utf-8 -*-

from odoo import models, fields, api, _
from odoo.tools.misc import formatLang, format_date, get_lang
import logging
_logger = logging.getLogger(__name__)


class AccountMove(models.Model):
    _inherit = "account.move"

    sent_date = fields.Datetime("Date d'envoi")
    
    def _get_accounting_date(self, invoice_date, has_tax):
        """Get correct accounting date for previous periods, taking tax lock date into account.
        When registering an invoice in the past, we still want the sequence to be increasing.
        We then take the last day of the period, depending on the sequence format.
        If there is a tax lock date and there are taxes involved, we register the invoice at the
        last date of the first open period.
        :param invoice_date (datetime.date): The invoice date
        :param has_tax (bool): Iff any taxes are involved in the lines of the invoice
        :return (datetime.date):
        """
        tax_lock_date = self.company_id.tax_lock_date
        today = fields.Date.today()
        if invoice_date and tax_lock_date and has_tax and invoice_date <= tax_lock_date:
            invoice_date = tax_lock_date + timedelta(days=1)

        if self.is_sale_document(include_receipts=True):
            return invoice_date
        elif self.is_purchase_document(include_receipts=True):            
            ### si facture d'achat on renvoie la date de facture
            return invoice_date
            
        return invoice_date
        
    @api.model
    def cron_account_invoice_send(self, today=False):
        """ Envoi des factures """
        if not today:
            today = fields.Date.today()        
        domain = [('move_type', '=', 'out_invoice'), ('invoice_date', '=', today), ('state', '=', 'posted'), ('is_move_sent', '=', False)]
        invoices = self.search(domain)
        _logger.info("INVOICES TO SEND %r",invoices)
        for invoice in invoices:
            template = self.env.ref('account.email_template_edi_invoice', False)
            lang = False
            lang = get_lang(self.env).code
            ctx = dict(
                default_model='account.move',
                default_res_id=self.id,
                # For the sake of consistency we need a default_res_model if
                # default_res_id is set. Not renaming default_model as it can
                # create many side-effects.
                default_res_model='account.move',
                default_use_template=bool(template),
                default_template_id=template and template.id or False,
                default_composition_mode='comment',
                mark_invoice_as_sent=True,
                custom_layout="mail.mail_notification_paynow",
                model_description=invoice.with_context(lang=lang).type_name,
                force_email=True
            )
            template.with_context(ctx).send_mail(invoice.id, force_send=False, raise_exception=False)
            
            invoice.is_move_sent = True
            invoice.sent_date = fields.Datetime.now(self)
    
    def get_recipients(self):
        self.ensure_one()
        recipients = []
        if self.sudo().partner_id.type == 'invoice':
            return self.sudo().partner_id.id
        
        for partner in self.sudo().partner_id.child_ids.filtered(lambda p: p.type == 'invoice'):
            recipients.append(str(partner.id))
        
        return ','.join(recipients)