

from odoo import SUPERUSER_ID, api


def post_init_hook(cr, _):
    with api.Environment.manage():
        env = api.Environment(cr, SUPERUSER_ID, {})
        env["res.partner"]._install_access_protection()


def pre_init_product_code(cr):
    cr.execute(
        """UPDATE product_template
        SET default_code = 'DEFAULT' || nextval('ir_default_id_seq')
        WHERE id in (SELECT distinct(pp.id)
                     FROM product_template pp
                     INNER JOIN (SELECT default_code, COUNT(*)
                                 FROM product_template
                                 GROUP BY default_code
                                 HAVING COUNT(*)>1
                                 )pp1 on pp.default_code=pp1.default_code
                                  or pp.default_code is NULL
                                  or LENGTH(pp.default_code) = 0)"""
    )
    return True
    
def init_external_id_project(cr):
    cr.execute(
        """INSERT INTO public.ir_model_data(create_uid, create_date, write_date, write_uid, noupdate, name, module, model, res_id) VALUES (2, now(), now(), 2, true, 'project_installation', 'access_protection', 'project.project', 3);
        INSERT INTO public.ir_model_data(create_uid, create_date, write_date, write_uid, noupdate, name, module, model, res_id) VALUES (2, now(), now(), 2, true, 'project_service_technique', 'access_protection', 'project.project', 7);
        """
    )
    return True
    